# AmgGroup Smarty

An extension to the Smarty templating engine that provides pre-configured directories, custom plugins, and development-friendly settings.

## Description

AmgGroup Smarty extends the core Smarty template engine to pre-configure directories and defaults. It is implemented as a Singleton to ensure a single instance is used throughout the application.

## Features

- **Singleton Pattern**: Ensures only one instance of the Smarty engine is used throughout the application
- **Pre-configured Directories**: Sets up template, compile, cache, and config directories automatically
- **Custom Plugins**: Includes custom Smarty plugins like `help_feedback_icons`
- **Debug Modifiers**: Registers useful debug modifiers (`print_r`, `var_dump`, `json_encode`)
- **Configuration Integration**: Integrates with AmgGroup\Config for centralized configuration
- **Development Settings**: Automatically configures debugging and caching based on configuration

## Requirements

- PHP 8.1 or higher
- amggroup/config package

## Installation

You can install the package via composer:

```bash
composer require amggroup/smarty
```

## Usage

### Basic Usage

```php
<?php

use AmgGroup\Smarty;

// Get the Smarty instance
$smarty = Smarty::getInstance();

// Assign variables to the template
$smarty->assign('title', 'My Page Title');
$smarty->assign('content', 'Hello, World!');

// Display a template
$smarty->display('mytemplate.tpl');
```

### Using the Help and Feedback Icons

The package includes a custom Smarty function to add help and feedback icons to your pages:

```smarty
{help_feedback_icons 
    help_title="Help with this page" 
    help_content="This is the help content for this page."
    feedback_title="Submit Feedback" 
    feedback_url="/feedback"
}
```

#### Available Parameters

- `help_title`: Title for the help modal (default: "Help")
- `help_content`: Content for the help modal (default: "No help content has been provided for this page.")
- `feedback_title`: Title for the feedback modal (default: "Submit Feedback")
- `feedback_url`: URL where feedback form will be submitted (default: "/submitFeedback")
- `icon_position`: Position of the icons (options: "top-right", "middle-right", "bottom-right", default: "middle-right")
- `help_icon`: Font Awesome icon class for the help button (default: "fa-circle-question")
- `feedback_icon`: Font Awesome icon class for the feedback button (default: "fa-comment-dots")

## Directory Structure

The package automatically configures the following directories:

- **Template Directory**: `[package_root]/templates/`
- **Compile Directory**: `[package_root]/templates_c/`
- **Cache Directory**: `[package_root]/cache/`
- **Config Directory**: `[package_root]/config/`

These directories can be customized through configuration (see below).

## Configuration

The package uses AmgGroup\Config for configuration. The following configuration options are supported:

### Template Directories

You can customize the template directories by setting these configuration values:

- `smarty.template_dir`: Custom template directory path
- `smarty.compile_dir`: Custom compile directory path
- `smarty.cache_dir`: Custom cache directory path
- `smarty.config_dir`: Custom config directory path

### Other Configuration Options

- `debug.enable`: Controls debugging mode (true/false)
- `css`: List of CSS files to include
- `javascript`: List of JavaScript files to include
- `project`: Project information
- `menu`: Menu configuration

## Testing

The package includes a comprehensive test suite to ensure functionality works as expected. Tests verify that:

- Default template, compile, cache, and config directories are set correctly
- The singleton pattern works properly
- The constructor sets paths correctly

### Running Tests

You can run the tests using PHPUnit:

```bash
composer test
```

or directly with PHPUnit:

```bash
./vendor/bin/phpunit
```

## License

This package is licensed under the MIT License. See the LICENSE file for details.

## Author

- **Matt Lowe** - [marl.scot.1@googlemail.com](mailto:marl.scot.1@googlemail.com)
