<?php

namespace Smarty;

/**
 * Mock of the Smarty\Smarty class for testing purposes
 */
class Smarty {
    protected $template_dir = [];
    protected $compile_dir = '';
    protected $cache_dir = '';
    protected $config_dir = [];
    
    public function __construct() {}
    
    public function setTemplateDir($dir) {
        $this->template_dir = is_array($dir) ? $dir : [$dir];
        return $this;
    }
    
    public function setCompileDir($dir) {
        $this->compile_dir = $dir;
        return $this;
    }
    
    public function setCacheDir($dir) {
        $this->cache_dir = $dir;
        return $this;
    }
    
    public function setConfigDir($dir) {
        $this->config_dir = is_array($dir) ? $dir : [$dir];
        return $this;
    }
    
    public function getTemplateDir() {
        return $this->template_dir;
    }
    
    public function getCompileDir() {
        return $this->compile_dir;
    }
    
    public function getCacheDir() {
        return $this->cache_dir;
    }
    
    public function getConfigDir() {
        return $this->config_dir;
    }
    
    public function assign($var, $value) {
        return $this;
    }
    
    public function registerPlugin($type, $name, $callback) {
        return $this;
    }
    
    public function getTemplateVars($var = null) {
        return null;
    }
    
    public function display($template = null, $cache_id = null, $compile_id = null) {
        return;
    }
}