<?php

namespace AmgGroup;

/**
 * Mock of the AmgGroup\Config class for testing purposes
 */
class Config {
    private static ?Config $instance = null;
    
    private function __construct() {}
    
    public static function getInstance(): Config {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function get($key) {
        // Return mock values based on the key
        switch ($key) {
            case 'debug.enable':
                return false;
            case 'css':
                return [];
            case 'javascript':
                return [];
            case 'project':
                return [];
            case 'menu':
                return [];
            default:
                return null;
        }
    }
}