<?php

namespace AmgGroup\Tests;

use AmgGroup\Session;
use PHPUnit\Framework\TestCase;
use phpmock\phpunit\PHPMock;

class SessionTest extends TestCase
{
    use PHPMock;

    /**
     * Set up function mocks in the global namespace
     */
    protected function setUp(): void
    {
        parent::setUp();
    }

    /**
     * Test that getTtyID returns a string
     */
    public function testGetTtyIDReturnsString()
    {
        // Mock the exec function to return a predictable value
        $exec = $this->getFunctionMock('AmgGroup', 'exec');
        $exec->expects($this->once())
            ->willReturn('/dev/tty1');

        $result = Session::getTtyID();

        $this->assertIsString($result);
        $this->assertEquals(md5('/dev/tty1'), $result);
    }

    /**
     * Test that start() starts a session if one is not already active
     */
    public function testStartStartsSession()
    {
        // Mock session_status to return PHP_SESSION_NONE
        $sessionStatus = $this->getFunctionMock('AmgGroup', 'session_status');
        $sessionStatus->expects($this->once())
            ->willReturn(PHP_SESSION_NONE);

        // Mock php_sapi_name to return 'apache'
        $phpSapiName = $this->getFunctionMock('AmgGroup', 'php_sapi_name');
        $phpSapiName->expects($this->once())
            ->willReturn('apache');

        // Expect session_start to be called once
        $sessionStart = $this->getFunctionMock('AmgGroup', 'session_start');
        $sessionStart->expects($this->once());

        Session::start();
    }

    /**
     * Test that start() sets the session ID in CLI environment
     */
    public function testStartSetsSessionIDInCLI()
    {
        // Mock session_status to return PHP_SESSION_NONE
        $sessionStatus = $this->getFunctionMock('AmgGroup', 'session_status');
        $sessionStatus->expects($this->once())
            ->willReturn(PHP_SESSION_NONE);

        // Mock php_sapi_name to return 'cli'
        $phpSapiName = $this->getFunctionMock('AmgGroup', 'php_sapi_name');
        $phpSapiName->expects($this->once())
            ->willReturn('cli');

        // Mock session_id to return empty string first time, then expect it to be set
        $sessionId = $this->getFunctionMock('AmgGroup', 'session_id');
        $sessionId->expects($this->exactly(2))
            ->willReturnOnConsecutiveCalls('', true);

        // Mock exec for the getTtyID call
        $exec = $this->getFunctionMock('AmgGroup', 'exec');
        $exec->expects($this->once())
            ->willReturn('/dev/tty1');

        // Expect session_start to be called once
        $sessionStart = $this->getFunctionMock('AmgGroup', 'session_start');
        $sessionStart->expects($this->once());

        Session::start();
    }

    /**
     * Test that start() does nothing if a session is already active
     */
    public function testStartDoesNothingIfSessionActive()
    {
        // Mock session_status to return PHP_SESSION_ACTIVE
        $sessionStatus = $this->getFunctionMock('AmgGroup', 'session_status');
        $sessionStatus->expects($this->once())
            ->willReturn(PHP_SESSION_ACTIVE);

        // Expect session_start to not be called
        $sessionStart = $this->getFunctionMock('AmgGroup', 'session_start');
        $sessionStart->expects($this->never());

        Session::start();
    }
}
