<?php

/**
 * Simple test runner script
 * 
 * This script runs the PHPUnit tests for the Session class.
 * It can be executed directly from the command line:
 * 
 * php run-tests.php
 * 
 * Or through Composer:
 * 
 * composer test
 */

// Check if PHPUnit is installed
if (!file_exists(__DIR__ . '/vendor/bin/phpunit')) {
    echo "PHPUnit not found. Please run 'composer install' first.\n";
    exit(1);
}

// Run the tests
$command = 'vendor/bin/phpunit';
$output = [];
$returnVar = 0;

echo "Running tests...\n";
exec($command, $output, $returnVar);

// Output the results
foreach ($output as $line) {
    echo $line . "\n";
}

// Return the exit code from PHPUnit
exit($returnVar);