# AmgGroup Session

A PHP library for session management with special handling for CLI environments.

## Installation

You can install the package via composer:

```bash
composer require amg-group/session
```

## Features

- Seamless session management across both web and CLI environments
- Consistent session persistence in CLI applications using terminal identifiers
- Simple API with static methods for easy integration

## Usage

### Basic Usage

```php
<?php

require_once 'vendor/autoload.php';

use AmgGroup\Session;

// Start a session
Session::start();

// Now you can use $_SESSION as usual
$_SESSION['example'] = 'value';

// Later in your application
Session::start(); // Won't start a new session if one is already active
echo $_SESSION['example']; // Outputs: value
```

### CLI Environment

In CLI environments, the library automatically uses a consistent session ID based on the terminal identifier, allowing session persistence across script executions:

```php
<?php
// script1.php
require_once 'vendor/autoload.php';

use AmgGroup\Session;

Session::start();
$_SESSION['cli_example'] = 'CLI value';
echo "Session value set\n";
```

```php
<?php
// script2.php
require_once 'vendor/autoload.php';

use AmgGroup\Session;

Session::start();
echo $_SESSION['cli_example']; // Outputs: CLI value
```

## API Reference

### Session::start()

Starts a PHP session if one is not already active. In CLI environments, it sets a consistent session ID based on the terminal identifier.

```php
Session::start();
```

### Session::getTtyID()

Gets a unique identifier based on the current terminal. This method is primarily used internally but can be called directly if needed.

```php
$ttyId = Session::getTtyID();
```

## Testing

The library includes a comprehensive test suite to ensure all functionality works as expected. The tests use PHPUnit and php-mock-phpunit to mock PHP functions.

### Running Tests

You can run the tests using Composer:

```bash
composer test
```

Or directly using the provided script:

```bash
php run-tests.php
```

### Test Coverage

The tests cover the following scenarios:

- Getting a unique terminal identifier with `getTtyID()`
- Starting a session in a web environment
- Starting a session in a CLI environment with automatic session ID setting
- Handling already active sessions

## License

The MIT License (MIT). Please see the [License File](LICENSE) for more information.
