# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.6.0] - 2026-01-08

### Added
- Support for string-based middleware references (e.g., `'MiddlewareClass@handle'`).

## [1.5.0] - 2026-01-08

### Added
- Support for individual route middleware in `add()`, `get()`, and `post()`.
- Improved middleware documentation and examples.

## [1.4.0] - 2026-01-08

### Added
- Route grouping support via `Router::group()`.
- Shared route prefixes for grouped routes.
- Middleware support for route groups and individual routes (via groups).
- Nested route groups.

## [1.3.0] - 2026-01-08

### Added
- Support for string-based route handlers (e.g., `'UserController@index'`).
- `Router::add()`, `get()`, `post()`, and `setNotFoundHandler()` now accept `string|callable`.

## [1.2.0] - 2026-01-08

### Added
- Introduction of `Response` objects.
- `Router::dispatch()` now returns a `Response` object instead of sending output directly.
- Handlers can now return a string or a `Response` object.

## [1.1.0] - 2026-01-08

### Added
- Support for HTTP methods (GET, POST, etc.) in routing.
- Shortcut methods `get()` and `post()` for registering routes.
- Dependency Injection support for `Config` and `Logger` in `Router` constructor.
- Support for custom 404 Not Found handlers via `setNotFoundHandler()`.
- Unit tests using PHPUnit.

### Changed
- `Router::add()` now requires HTTP method as the first parameter.
- `Router::dispatch()` now accepts optional HTTP method (defaults to 'GET').
- Fixed URI normalization to correctly handle the root path `/`.
- Fixed PSR-4 autoloading namespace in `composer.json`.

## [1.0.0] - 2024-01-01
