<?php

use PHPUnit\Framework\TestCase;
use AmgGroup\Currency;
use AmgGroup\Language;
use AmgGroup\Locale;

class HelpersTest extends TestCase
{
    public function testCurrencyDataLoads(): void
    {
        $currencies = new Currency();
        $this->assertGreaterThan(0, count($currencies));
        $this->assertArrayHasKey('USD', $currencies->get());
        $this->assertSame('US Dollar', $currencies['USD']);
        $this->assertArrayHasKey('EUR', $currencies->get());
        $this->assertSame('Euro', $currencies['EUR']);
    }

    public function testLanguageDataLoads(): void
    {
        $languages = new Language();
        $this->assertGreaterThan(0, count($languages));
        $this->assertArrayHasKey('en', $languages->get());
        $this->assertSame('English', $languages['en']);
    }

    public function testLocaleDataLoads(): void
    {
        $locales = new Locale();
        $this->assertGreaterThan(0, count($locales));
        $this->assertArrayHasKey('en_GB', $locales->get());
        $this->assertSame('English (United Kingdom)', $locales['en_GB']);
        $this->assertArrayHasKey('en_US', $locales->get());
        $this->assertSame('English (United States)', $locales['en_US']);
    }
}
