<?php

namespace AmgGroup;
final class MsGraphClientCredentialsTokenProvider implements TokenProviderInterface
{
    public function __construct(
        private readonly \GuzzleHttp\ClientInterface $http,
        private readonly string $tenantId,
        private readonly string $clientId,
        private readonly string $clientSecret,
        private readonly string $scope = 'https://graph.microsoft.com/.default',
    ) {}

    private ?string $token = null;
    private int $expiresAt = 0;

    public function getAccessToken(): string
    {
        if ($this->token && time() < $this->expiresAt - 60) {
            return $this->token;
        }

        $tokenEndpoint = "https://login.microsoftonline.com/{$this->tenantId}/oauth2/v2.0/token";
        $response = $this->http->request('POST', $tokenEndpoint, [
            'form_params' => [
                'client_id' => $this->clientId,
                'client_secret' => $this->clientSecret,
                'grant_type' => 'client_credentials',
                'scope' => $this->scope,
            ],
        ]);

        $data = json_decode((string)$response->getBody(), true);
        $this->token = $data['access_token'] ?? '';
        $this->expiresAt = time() + (int)($data['expires_in'] ?? 3600);
        return $this->token;
    }
}
