<?php

declare(strict_types=1);

namespace AmgGroup\Tests;

use AmgGroup\GraphQuery;
use PHPUnit\Framework\TestCase;

final class GraphQueryTest extends TestCase
{
    public function testBuildsArrayAndQueryString(): void
    {
        $q = GraphQuery::create()
            ->select(['id', 'displayName'])
            ->filter("displayName eq 'Alice'")
            ->top(5)
            ->orderBy(['displayName desc'])
            ->expand(['memberOf']);

        $arr = $q->toArray();
        $this->assertSame([
            '$select' => 'id,displayName',
            '$filter' => "displayName eq 'Alice'",
            '$top' => 5,
            '$orderby' => 'displayName desc',
            '$expand' => 'memberOf',
        ], $arr);

        $qs = $q->toQueryString();
        // http_build_query ordering may vary; assert contains pieces
        $this->assertStringContainsString('%24select=id%2CdisplayName', $qs);
        $this->assertStringContainsString('%24filter=displayName+eq+%27Alice%27', $qs);
        $this->assertStringContainsString('%24top=5', $qs);
        $this->assertStringContainsString('%24orderby=displayName+desc', $qs);
        $this->assertStringContainsString('%24expand=memberOf', $qs);
    }
}
