<?php

namespace AmgGroup;

final class Filter
{
    public static function eq(string $field, string|int|bool $value): string
    {
        return sprintf('%s eq %s', $field, self::literal($value));
    }

    public static function ne(string $field, string|int|bool $value): string
    {
        return sprintf('%s ne %s', $field, self::literal($value));
    }

    public static function contains(string $field, string $value): string
    {
        return sprintf("contains(%s,%s)", $field, self::literal($value));
    }

    public static function startsWith(string $field, string $value): string
    {
        return sprintf("startsWith(%s,%s)", $field, self::literal($value));
    }

    public static function in(string $field, array $values): string
    {
        $lits = array_map([self::class, 'literal'], $values);
        return sprintf('%s in (%s)', $field, implode(',', $lits));
    }

    public static function not(string $expr): string
    {
        return sprintf('not (%s)', $expr);
    }

    public static function and(string ...$expr): string
    {
        $expr = array_filter($expr, static fn($e) => $e !== null && $e !== '');
        return implode(' and ', array_map(static fn($e) => '(' . $e . ')', $expr));
    }

    public static function or(string ...$expr): string
    {
        $expr = array_filter($expr, static fn($e) => $e !== null && $e !== '');
        return implode(' or ', array_map(static fn($e) => '(' . $e . ')', $expr));
    }

    private static function literal(string|int|bool $value): string
    {
        if (is_bool($value)) {
            return $value ? 'true' : 'false';
        }
        if (is_int($value)) {
            return (string)$value;
        }
        // OData string escaping: single quote doubled
        $escaped = str_replace("'", "''", $value);
        return "'{$escaped}'";
    }
}
