<?php

declare(strict_types=1);

namespace AmgGroup\Tests;

use AmgGroup\Filter;
use PHPUnit\Framework\TestCase;

final class FilterTest extends TestCase
{
    public function testEqAndEscaping(): void
    {
        $this->assertSame("displayName eq 'O''Reilly'", Filter::eq('displayName', "O'Reilly"));
        $this->assertSame('age eq 30', Filter::eq('age', 30));
        $this->assertSame('enabled eq true', Filter::eq('enabled', true));
    }

    public function testLogicalBuilders(): void
    {
        $expr = Filter::and(
            Filter::eq('userPrincipalName', 'alice@example.com'),
            Filter::or(
                Filter::contains('displayName', 'Alice'),
                Filter::startsWith('mail', 'alice')
            )
        );
        $this->assertSame(
            "(userPrincipalName eq 'alice@example.com') and (" .
            "(contains(displayName,'Alice')) or (startsWith(mail,'alice')))",
            $expr
        );
    }

    public function testInAndNot(): void
    {
        $expr = Filter::not(Filter::in('role', ['Admin', 'User']));
        $this->assertSame("not (role in ('Admin','User'))", $expr);
    }
}
