Split into multiple classes

* Users -> Any methods required for reading/wrighting user data
* * Data : users -> List of all users
* * Data : enabled -> List of enabled users
* CondidionalAccess -> Any methods relating to CA access
* * Locations -> List of named locations
* * Countries -> List of countries
* * Policies -> List of CA Policies

All data should be stored and indexed by the UUID of each object

Methods that need to access online API :

* public function getAllUsers($active = true)
* public function getConditionalAccessNamedLocations($reindex = true)
* public function getConditionalAccessPolicies($reindex = true)
* public function deleteConditionalAccessPolicy($policyId)
* public function createConditionalAccessPolicy($policy)
* public function updateConditionalAccessPolicy($policyId, $policy): bool


Methods that just re-index existing data

* public function getUserByUUID($uuid)
* public function getConditionalAccessPolicyByName($policyName)
* public function getConditionalAccessPolicyByID($policyId)
* public function getConditionalAccessPolicyIdByName($policyName)
* public function getNamedSingleLocation(string $countryCode)
* public function getNamedSingleLocationByName(string $policyName)


Generic Methods 

* none just now



