<?php

namespace AmgGroup;

class WritableDataArray implements \ArrayAccess, \Iterator, \Countable
{
    private array $data;
    private MSGraphBase $parent;
    private string $dataSet;
    private int $position = 0;

    public function __construct(array $data, MSGraphBase $parent, string $dataSet)
    {
        $this->data = $data;
        $this->parent = $parent;
        $this->dataSet = $dataSet;
    }

    // ArrayAccess implementation
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->data[$offset]);
    }

    public function offsetGet(mixed $offset): mixed
    {
        return $this->data[$offset] ?? null;
    }

    public function offsetSet(mixed $offset, mixed $value): void
    {
        $oldValue = $this->data[$offset] ?? null;
        $this->data[$offset] = $value;

        // Mark as dirty if value actually changed
        if ($oldValue !== $value) {
            $this->parent->markDirty($this->dataSet, $offset, $value);
        }
    }

    public function offsetUnset(mixed $offset): void
    {
        if (isset($this->data[$offset])) {
            unset($this->data[$offset]);
            $this->parent->markDirty($this->dataSet, $offset, null, 'delete');
        }
    }

    // Iterator implementation
    public function rewind(): void
    {
        $this->position = 0;
    }

    public function current(): mixed
    {
        $keys = array_keys($this->data);
        return $this->data[$keys[$this->position]] ?? null;
    }

    public function key(): mixed
    {
        $keys = array_keys($this->data);
        return $keys[$this->position] ?? null;
    }

    public function next(): void
    {
        ++$this->position;
    }

    public function valid(): bool
    {
        $keys = array_keys($this->data);
        return isset($keys[$this->position]);
    }

    // Countable implementation
    public function count(): int
    {
        return count($this->data);
    }

    // Get the underlying array
    public function toArray(): array
    {
        return $this->data;
    }
}