<?php

namespace AmgGroup;

include_once __DIR__ . '/../vendor/autoload.php';

class Countries extends MSGraphBase
{
    const CACHE_KEY = 'countries';

    protected array $cacheDefaults = [
        'Countries' => 3600,
    ];

    /**
     * @used This method is called dynamically from fetchFromApi
     * @noinspection PhpUnusedPrivateMethodInspection
     *
     * @return array
     */
    protected function getCountries(): array
    {
        $originalCountries = require __DIR__.'/../vendor/umpirsky/country-list/data/en/country.php';
        // Sanitize country names to ensure only a-zA-Z& characters
        $countries = [];
        foreach ($originalCountries as $code => $name) {
            // Convert to ASCII (transliterate), then filter out unwanted characters
            $asciiName = transliterator_transliterate('Any-Latin; Latin-ASCII', $name);
            // Keep only a-zA-Z& and spaces
            $sanitizedName = preg_replace('/[^a-zA-Z& ]/', '', $asciiName);
            // Trim extra spaces and store
            $countries[$code] = trim(preg_replace('/\s+/', ' ', $sanitizedName));
        }

        return $countries;
    }

    /**
     * @used This method is called dynamically from fetchFromApi
     * @noinspection PhpUnusedPrivateMethodInspection
     *
     * @return array
     */
    protected function getCountryCodes(): array
    {
        $countries=$this['Countries'];
        $names=[];
        foreach ($countries as $code => $name) {
            $names[$name]=$code;
        }
        return $names;
    }


}