<?php

namespace AmgGroup\Tests\Mocks;

/**
 * Mock Config class for testing
 */
class Config
{
    private static ?Config $instance = null;
    private array $config = [];

    /**
     * Get the singleton instance
     *
     * @return Config
     */
    public static function getInstance(): Config
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Reset the singleton instance (for testing)
     */
    public static function resetInstance(): void
    {
        self::$instance = null;
    }

    /**
     * Set a configuration value
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, $value): void
    {
        $this->config[$key] = $value;
    }

    /**
     * Get a configuration value
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get(string $key, $default = null)
    {
        return $this->config[$key] ?? $default;
    }
}