# LDAP Authenticator

A PHP library for authenticating users against Active Directory via LDAP.

## Features

- User authentication against Active Directory LDAP servers
- Support for multiple username formats (username, domain\username, user@domain.com)
- Group membership verification
- Password expiration detection
- Singleton implementation for efficient connection management
- Customizable base DNs for searching
- Comprehensive error handling

## Requirements

- PHP 8.0 or higher
- PHP LDAP extension

## Installation

Install the package via Composer:

```bash
composer require amggroup/ldap-authenticator
```

## Configuration

This library requires configuration values to be set in a compatible configuration system. You'll need to set the following values:

```php
// Required for authentication
'authentication.DOMAIN_FQDN' => 'example.local', // Your Active Directory domain
'authentication.LDAP_SERVER' => 'ldap.example.local', // Your LDAP server address

// Required for group membership checks
'authentication.SERVICE_USERNAME' => 'service_account@example.local', // Service account username
'authentication.SERVICE_PASSWORD' => 'password', // Service account password
```

## Usage

### Basic Authentication

```php
<?php

$ldap = \AmgGroup\LdapAuthenticator::getInstance();

// Authenticate a user
if ($ldap->authenticate('username', 'password')) {
    echo "Authentication successful!";
} else {
    echo "Authentication failed: " . $ldap->getLastError();
}
```

### Group Membership Verification

```php
<?php

$ldap = \AmgGroup\LdapAuthenticator::getInstance();

// Check if a user is a member of a group
if ($ldap->isInGroup('username', 'GroupName')) {
    echo "User is a member of the group!";
} else {
    echo "User is not a member of the group: " . $ldap->getLastError();
}
```

### Customizing Base DNs

```php
<?php

$ldap = \AmgGroup\LdapAuthenticator::getInstance();

// Add a specific OU to search
$ldap->addBaseDn('OU=Users,DC=example,DC=local');

// Or completely replace the base DNs
$ldap->setBaseDns([
    'OU=Staff,DC=example,DC=local',
    'OU=Contractors,DC=example,DC=local'
]);
```

## Error Handling

The library provides detailed error messages which can be retrieved using the `getLastError()` method after any operation fails.

## License

MIT
