<?php

namespace AmgGroup\Tests\Drivers;

use AmgGroup\Drivers\YamlDriver;
use PHPUnit\Framework\TestCase;

class YamlDriverTest extends TestCase
{
    public function testLoadAndDumpRoundTrip(): void
    {
        $driver = new YamlDriver();
        $this->assertTrue($driver->supports('config.yaml'));
        $this->assertTrue($driver->supports('config.yml'));

        $data = [
            'db' => ['host' => 'localhost', 'port' => 5432],
            'debug' => true,
        ];

        $tmp = tempnam(sys_get_temp_dir(), 'yaml');
        $this->assertNotFalse($tmp);
        $driver->dump($data, $tmp);

        $loaded = $driver->load($tmp);
        $this->assertSame($data, $loaded);

        @unlink($tmp);
    }
}
