<?php

namespace AmgGroup;

interface ConfigInterface
{
    /**
     * Return the value from the config key requested
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get(string $key, mixed $default = null): mixed;

    /**
     * Set a config key to a value
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, mixed $value): void;

    /**
     * Check if any configs have been loaded
     * @return bool
     */
    public function isEmpty(): bool;

    /**
     * Return an array of config paths that have been loaded
     * @return array
     */
    public function getLoadedPaths(): array;

    /**
     * Return an array of config paths that have been skipped for what ever reason
     * @return array
     */
    public function getSkippedPaths(): array;
}