<?php

namespace AmgGroup\Drivers;

use AmgGroup\ConfigDriverInterface;

class JsonDriver implements ConfigDriverInterface
{
    public function supports(string $path): bool
    {
        return str_ends_with(strtolower($path), '.json');
    }

    public function load(string $path): array
    {
        $raw = file_get_contents($path);
        if ($raw === false) {
            throw new \RuntimeException("Failed to read JSON config: {$path}");
        }
        $data = json_decode($raw, true);
        if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
            throw new \RuntimeException('JSON decode error: '.json_last_error_msg());
        }
        return is_array($data) ? $data : [];
    }

    public function dump(array $data, string $path): void
    {
        $json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        if ($json === false) {
            throw new \RuntimeException('JSON encode error: '.json_last_error_msg());
        }
        if (file_put_contents($path, $json) === false) {
            throw new \RuntimeException("Failed to write JSON config: {$path}");
        }
    }
}
