<?php

namespace AmgGroup;

use AmgGroup\DriverRegistryInterface;

class DriverRegistry implements DriverRegistryInterface
{
    /**
     * @param ConfigDriverInterface[] $drivers
     */
    public function __construct(private iterable $drivers)
    {
    }

    public function resolve(string $path): ConfigDriverInterface
    {
        foreach ($this->drivers as $driver) {
            if ($driver->supports($path)) {
                return $driver;
            }
        }
        throw new \InvalidArgumentException("No config driver available for path: {$path}");
    }
}
