<?php

namespace AmgGroup;

interface ConfigDriverInterface
{
    /** Return true if this driver can handle the given path (by extension or sniff). */
    public function supports(string $path): bool;

    /** Load file into an array. Throw a domain exception on parse errors. */
    public function load(string $path): array;

    /** Dump data to the given path. Throw on write/serialize errors. */
    public function dump(array $data, string $path): void;
}
