<?php

namespace AmgGroup\Tests\Drivers;

use AmgGroup\Drivers\JsonDriver;
use PHPUnit\Framework\TestCase;

class JsonDriverTest extends TestCase
{
    public function testLoadAndDumpRoundTrip(): void
    {
        $driver = new JsonDriver();
        $this->assertTrue($driver->supports('config.json'));

        $data = [
            'service' => ['url' => 'https://example.com', 'timeout' => 30],
            'enabled' => false,
        ];

        $tmp = tempnam(sys_get_temp_dir(), 'json');
        $this->assertNotFalse($tmp);
        $driver->dump($data, $tmp);

        $loaded = $driver->load($tmp);
        $this->assertSame($data, $loaded);

        @unlink($tmp);
    }
}
