<?php

namespace AmgGroup\Drivers;

use AmgGroup\ConfigDriverInterface;
use Symfony\Component\Yaml\Yaml;

class YamlDriver implements ConfigDriverInterface
{
    public function supports(string $path): bool
    {
        $p = strtolower($path);
        return str_ends_with($p, '.yml') || str_ends_with($p, '.yaml');
    }

    public function load(string $path): array
    {
        $data = Yaml::parseFile($path);
        return is_array($data) ? $data : [];
    }

    public function dump(array $data, string $path): void
    {
        $yaml = Yaml::dump($data, 4, 2, Yaml::DUMP_OBJECT_AS_MAP);
        file_put_contents($path, $yaml);
    }
}
