<?php

namespace AmgGroup;

class DriverRegistry
{
    /**
     * @param ConfigDriverInterface[] $drivers
     */
    public function __construct(private array $drivers)
    {
    }

    public function resolve(string $path): ConfigDriverInterface
    {
        foreach ($this->drivers as $driver) {
            if ($driver->supports($path)) {
                return $driver;
            }
        }
        throw new \InvalidArgumentException("No config driver available for path: {$path}");
    }
}
