<?php

namespace AmgGroup\Tests\Drivers;

use AmgGroup\Drivers\IniDriver;
use PHPUnit\Framework\TestCase;

class IniDriverTest extends TestCase
{
    public function testLoadAndDumpRoundTrip(): void
    {
        $driver = new IniDriver();
        $this->assertTrue($driver->supports('config.ini'));

        $data = [
            'section' => ['a' => 1, 'b' => true],
            'flag' => false,
        ];

        $tmp = tempnam(sys_get_temp_dir(), 'ini');
        $this->assertNotFalse($tmp);
        $driver->dump($data, $tmp);

        $loaded = $driver->load($tmp);
        // INI round-trip preserves structure for simple scalars and sections
        $this->assertSame($data['section'], $loaded['section']);
        $this->assertArrayHasKey('flag', $loaded);
        $this->assertIsBool($loaded['flag']);

        @unlink($tmp);
    }
}
