# Config Library

A PHP configuration library that loads and manages configuration from YAML files with support for environment variable management.

## Installation

You can install the package via composer:

```bash
composer require yourvendor/config
```

## Usage

### Basic Usage

```php
use AmgGroup\Config;

// Get the configuration instance
$config = Config::getInstance();

// Get a configuration value
$dbHost = $config->get('database.host');

// Get a value with a default fallback
$debug = $config->get('app.debug', false);

// Set a configuration value
$config->set('app.environment', 'production');

// Get all configuration
$allConfig = $config->getAll();
```

### Configuration Files

By default, the library looks for configuration files in the following locations:

- Default configuration: `/config/default.yml`
- Local configuration: `/config/local.yml` (overrides default values)

You can specify custom paths when getting the instance:

```php
$config = Config::getInstance('/path/to/default.yml', '/path/to/local.yml');
```

### Environment Variables

The library can automatically set environment variables from the configuration. Add an `env` section to your YAML file:

```yaml
env:
  APP_ENV: production
  DEBUG: false
```

## Testing

The library includes a comprehensive test suite. To run the tests:

1. Install development dependencies:

```bash
composer install
```

2. Run the tests:

Using Composer:

```bash
composer test
```

Or directly with PHPUnit:

```bash
./vendor/bin/phpunit
```

Or on Windows:

```bash
vendor\bin\phpunit
```

## License

The MIT License (MIT). Please see [the License File](LICENSE.md) for more information.
