# Composer File Copier

A Composer plugin to copy files and directories during package installation or update, based on configuration in your root `composer.json`.

## Installation

```bash
composer require amggroup/composer-file-copier
```

## Configuration

Add the `file-copier` configuration to the `extra` section of your root `composer.json`.

### Options

* `failOnError`: (boolean) If true, the installation will stop if an error occurs during copying. Default: `false`.
* `copies`: (array) A list of copy tasks.

### Copy Task Properties

Each copy task supports:

```json
{
  "source": "optional (file or directory path)",
  "glob": "optional (string) or [string, string, ...]",
  "exclude": "optional (string) or [string, string, ...]",
  "target": "required (file or directory path)",
  "recursive": false,
  "overwrite": true,
  "mode": "0644",
  "dirMode": "0755"
}
```

### Rules

1.  **Glob Precedence**: If `glob` is provided, it takes precedence over `source`, and `target` is treated as a directory.
2.  **Mirroring**: Destination paths mirror the matched paths relative to the non-wildcard base of the pattern.
3.  **Excludes**: `exclude` patterns apply to:
    *   Directory copies (both recursive and non-recursive).
    *   Glob results (and their recursive copies).
4.  **Pattern Support**:
    *   `*`, `?`, `**` (globstar across directories).
    *   Basic `{a,b}` brace expansion.
    *   Character classes like `[a-z]`.
    *   Patterns are matched against the project-root-relative path with forward slashes.
5.  **Directory matches with `recursive: false`**: When a directory itself matches a glob, it’s created at the destination without its contents (shallow).
6.  **Windows**: `chmod` is best-effort and may have no effect.

## Example Usage

```json
{
  "extra": {
    "file-copier": {
      "failOnError": false,
      "copies": [
        {
          "source": "resources/config/app.ini",
          "target": "public/app.ini",
          "mode": "0644"
        },
        {
          "source": "resources/assets",
          "target": "public/assets",
          "recursive": true,
          "mode": "0644",
          "dirMode": "0755",
          "exclude": [
            "**/*.map",
            "**/drafts/**"
          ]
        },
        {
          "glob": "resources/img/**/*.png",
          "target": "public/img",
          "overwrite": true
        },
        {
          "glob": [
            "resources/snippets/**/*.{txt,md}",
            "resources/docs/**/*.md"
          ],
          "exclude": [
            "**/WIP/**",
            "**/*.draft.md"
          ],
          "target": "public/docs",
          "recursive": false,
          "mode": "0644",
          "dirMode": "0755"
        }
      ]
    }
  }
}
```

### Glob Base & Mirroring

For a pattern like `resources/img/**/*.png`, the base is `resources/img`. If a file matches at `resources/img/icons/ui/add.png`, it’s copied to `<target>/icons/ui/add.png`.

## License

MIT
