<?php

// Lightweight PSR-16 CacheInterface polyfill for environments where psr/simple-cache
// is not installed at runtime. If the real interface exists, this file is inert.

namespace Psr\SimpleCache;

if (!interface_exists(CacheInterface::class)) {
    /**
     * Minimal subset matching PSR-16 signatures loosely to avoid type conflicts.
     */
    interface CacheInterface
    {
        public function get($key, $default = null);
        public function set($key, $value, $ttl = null): bool;
        public function delete($key): bool;
        public function clear(): bool;
        public function getMultiple($keys, $default = null): iterable;
        public function setMultiple($values, $ttl = null): bool;
        public function deleteMultiple($keys): bool;
        public function has($key): bool;
    }
}
